/***************************************************************************/
/*  USART0 (polling) driver for NXP LPC15xx microcontrollers.             */
/***************************************************************************/
#include "global.h"

const char ascii[] = "0123456789ABCDEF";

void USART0_Init(uint32_t br)
/***************************/
{
	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_UART0 );			// Enable USART0,1,2 clocks

	Chip_SYSCTL_PeriphReset(RESET_UART0);						// de-assert USART0 reset
	
	Chip_SWM_MovablePortPinAssign(SWM_UART0_TXD_O, 2, 6);		// assign U0 TXD to P2_6 ASSIGN0(7:0)

	Chip_SWM_MovablePortPinAssign(SWM_UART0_RXD_I, 2, 7);		// assign U0_RXD to P2_7 ASSIGN0(15:8)


    LPC_SYSCON->UARTCLKDIV      = 1;               				// divided by 1
	
    Chip_UART_SetBaud(LPC_USART0, (SystemCoreClock/16/br)-1);	// baud rate


    Chip_UART_ConfigData(LPC_USART0, UART_CFG_DATALEN_8 |
    								 UART_CFG_ENABLE	);		// 8 bits, no Parity, 1 Stop bit

}

char ua_inchar(void)	                           				// look if there is a character available
/******************/
{
    if (LPC_USART0->STAT & (1<<0))
        return LPC_USART0->RXDATA & 0x7F;           			// yes, return character from input buffer
    else
        return 0xFF;                               				// no, return -1
}

char ua_getchar(void)                              				// wait for a character
/*******************/
{
    while (!(LPC_USART0->STAT & (1<<0))) ;          			// receiver ready?
    return LPC_USART0->RXDATA & 0x7F;               			// read character from input buffer
}

void ua_outchar(char c)		
/*********************/
{
    while (!(LPC_USART0->STAT & (1<<2))) ;          			// transmitter ready?
    LPC_USART0->TXDATA = c;
}

void PrintByte(unsigned char b)
/*****************************/
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
/******************************/
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

void PrintString(const char *s)
/*****************************/
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                      			// output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
